function TMi = T(i,Mi)

% Computes T(Mi) given (i,Mi).  

%-------
% setup
%-------

% global

global beta plr Pr_data x_data n NA NY NW jstate

% allocate memory

TMi(NW(i)) = struct;

%-------------
% computation
%-------------

for wip=1:NW(i)
    
    % compute ext_cand
    
    ext_cand = [];
    
    for wi=1:NW(i)
      
      if (Mi(wi).emp==0) % proceed only if belief set is non-empty
        
        for j=1:size(Mi(wi).ext,1); for ai=1:NA(i); for yi=1:NY(i)
              
              if (plr(i).wp(wi,ai,yi)==wip) % valid candidate
                ext_cand = [ext_cand; B(i,Mi(wi).ext(j,:),ai,yi)];
              end
                            
        end; end; end
      
      end
    
    end
    
    % compute T(Mi)(wip)
    
    if (size(ext_cand,1)==0) % no candidate ext pts
        
        TMi(wip).emp = 1;   % empty belief set
        TMi(wip).ext = NaN; % give NaN for ext pts
    
    else % there exist candidate ext pts
        
        TMi(wip).emp = 0;                 % non-empty belief set
        TMi(wip).ext = extblfs(ext_cand); % record extreme points
        
    end
    
end

